/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.data.DamageSourceDescription;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.BiEntityAction;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributedDamageAction
extends BiEntityAction<Configuration> {
    public AttributedDamageAction() {
        super(Configuration.CODEC);
    }

    public void execute(Configuration configuration, Entity actor, Entity target) {
        if (!(actor instanceof LivingEntity) || target == null) {
            return;
        }
        float baseDamage = configuration.base();
        Configuration.Modifier modifier = configuration.modifier().orElse(null);
        if (modifier != null) {
            ResourceLocation attributeLocation = modifier.attribute();
            ResourceKey attributeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256728_, (ResourceLocation)attributeLocation);
            Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_6246_(attributeKey);
            AttributeModifier.Operation operation = modifier.operation();
            float modifierValue = modifier.value();
            if (attribute != null) {
                LivingEntity livingActor = (LivingEntity)actor;
                double attributeValue = livingActor.m_21133_(attribute);
                switch (operation) {
                    case ADDITION: {
                        baseDamage = (float)((double)baseDamage + attributeValue * (double)modifierValue);
                        break;
                    }
                    case MULTIPLY_BASE: {
                        baseDamage = (float)((double)baseDamage + (double)baseDamage * attributeValue * (double)modifierValue);
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        baseDamage = (float)((double)baseDamage + (double)baseDamage * attributeValue * (double)modifierValue);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown operation: " + operation);
                    }
                }
            }
        }
        DamageSource source = MiscUtil.createDamageSource((DamageSources)actor.m_269291_(), (DamageSourceDescription)configuration.source().orElse(null), (ResourceKey)configuration.damageType().orElse(null), (Entity)actor);
        target.m_6469_(source, baseDamage);
    }

    public static class Configuration
    implements IDynamicFeatureConfiguration {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("base").forGetter(Configuration::base), (App)CalioCodecHelper.optionalField(Modifier.CODEC, (String)"modifier").forGetter(Configuration::modifier), (App)CalioCodecHelper.optionalField((Codec)ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, (String)"source").forGetter(Configuration::source), (App)CalioCodecHelper.optionalField((Codec)SerializableDataTypes.DAMAGE_TYPE, (String)"damage_type").forGetter(Configuration::damageType)).apply((Applicative)instance, Configuration::new));
        private final float base;
        private final Optional<Modifier> modifier;
        private final Optional<DamageSourceDescription> source;
        private final Optional<ResourceKey<DamageType>> damageType;

        public Configuration(float base, Optional<Modifier> modifier, Optional<DamageSourceDescription> source, Optional<ResourceKey<DamageType>> damageType) {
            this.base = base;
            this.modifier = modifier;
            this.source = source;
            this.damageType = damageType;
        }

        public float base() {
            return this.base;
        }

        public Optional<Modifier> modifier() {
            return this.modifier;
        }

        public Optional<DamageSourceDescription> source() {
            return this.source;
        }

        public Optional<ResourceKey<DamageType>> damageType() {
            return this.damageType;
        }

        public static class Modifier {
            public static final Codec<Modifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.IDENTIFIER.fieldOf("attribute").forGetter(Modifier::attribute), (App)SerializableDataTypes.MODIFIER_OPERATION.fieldOf("operation").forGetter(Modifier::operation), (App)Codec.FLOAT.fieldOf("value").forGetter(Modifier::value)).apply((Applicative)instance, Modifier::new));
            private final ResourceLocation attribute;
            private final AttributeModifier.Operation operation;
            private final float value;

            public Modifier(ResourceLocation attribute, AttributeModifier.Operation operation, float value) {
                this.attribute = attribute;
                this.operation = operation;
                this.value = value;
            }

            public ResourceLocation attribute() {
                return this.attribute;
            }

            public AttributeModifier.Operation operation() {
                return this.operation;
            }

            public float value() {
                return this.value;
            }
        }
    }
}

